<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class MCOController extends Controller{
    public function getMCO($anio, $rfce, $nonce){
        $pdo = DB::connection()->getPdo();
        $encController = new EncController();
        $rfce = $encController->desencriptar(base64_encode($rfce . "|" . $nonce));

        $qry = "SELECT * FROM S001V01TDIFE WHERE DIFE_ANIO = :anio AND DIFE_ESTA != 'Eliminado' AND DIFE_RFCE = :rfce";
        $gst = $pdo->prepare($qry);

        $gst->bindParam(":anio", $anio);
        $gst->bindParam(":rfce", $rfce);

        if(!$gst->execute()){
            return $this->makeResponse(true, "ERR_MESMPR_SER_GMC000: No se ejecutó la consulta del año requerido", [], 500);
        }

        $dias = $gst->fetchAll($pdo::FETCH_ASSOC);
        if(count($dias) == 0){
            return $this->makeResponse(true, "ERR_MESMPR_USU_GMC001: Los días feriados para el año $anio no han sido configurados");
        }

        return $this->makeResponse(false, "EXITO: Año configurado");
    }

    private function makeResponse($error, $msg, $response = [], $code = 200){
        $respuesta = json_encode([
            "error" => $error,
            "msg" => $msg,
            "response" => $response
        ]);

        return response($respuesta, $code)->header('Content-Type', 'application/json');
    }
}